﻿package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import MoviesHolder;
	import flash.geom.Rectangle;
	import flash.geom.Point;
	import flash.text.*;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	
	
	public class ImagesEditPanel extends MovieClip{		
		public var arrImages:Array = new Array();
		public var mc_holder:MoviesHolder;
		public var imagePath:String = "";
		public var mc_uploader:Uploader = new Uploader();
		public var dispatcher:EventDispatcher = new EventDispatcher();
		public var mc_mask:Sprite = new Sprite();
		
		//the gaps in x and y axes for mask
		public var items_gapx:Number = 20;
		public var items_gapy:Number = 14;		
		public var items_gapx_bottom:Number = 0;
		public var items_gapy_bottom:Number = 14;
		
		public var mc_itemsArea:Sprite = new Sprite();
		public var flagSelectionStarted = false;
		public var selHolderStartPoint:Point;
		public var selectionStartPoint:Point;
		public var selRectangle:Shape = new Shape;
		public var currentCategoryId:Number = -1;
		public var flagStageLoaded:Boolean = false;
		
		//inline elements:
		
		//mc_back
		//mc_scrollBar
		//mc_noItemsText
		//txtCategoryCaption
		
		//constructor:
		public function ImagesEditPanel(){			
		}
		
		//---------------------------------------------------------------------
		//init panel with movies holder
		public function initPanel(urlUpload:String){
			mc_noItemsText.visible = false;
			this.mc_back.visible = false;				
			
			setContextMenu();
			
			//setup items area (transparent)
			fillMovieItemsArea(this.mc_itemsArea);
			this.mc_itemsArea.alpha = 0;
			
			//swap depths between the scrollbar and items area. (to avoid overlapping)
			this.swapChildren(this.mc_itemsArea,this.mc_scrollBar);

			//setup mask
			fillMovieItemsArea_mask(this.mc_mask);
						
			//position holder
			this.mc_holder = new MoviesHolder(this.mc_mask.width,this.mc_mask.height);
			
			this.mc_holder.mask = this.mc_mask;

			//holder events:
			this.mc_holder.dispatcher.addEventListener("holderItemBeginLoading", holderItemBeginLoading);
			this.mc_holder.dispatcher.addEventListener("holderLoadingInProcess", holderLoadingInProcess);
			this.mc_holder.dispatcher.addEventListener("holderItemLoaded", holderItemLoaded);
			this.mc_holder.dispatcher.addEventListener("allHolderItemsLoaded", allHolderImagesLoaded);
			
			//uploader events
			this.mc_uploader.dispatcher.addEventListener("uploadCompleted", uploadCompetedHandler);
			this.mc_uploader.dispatcher.addEventListener("uploadStarted", uploadStartedHandler);
			
			var website = this.parent;
						
			//top panel events:
			website.mc_topPanel.dispatcher.addEventListener("uploadButtonClick", uploadButtonClick);
			website.mc_topPanel.dispatcher.addEventListener("deleteButtonClick", deleteButtonClick);
			website.mc_topPanel.dispatcher.addEventListener("editNameClick", editNameButtonClick);
			website.mc_topPanel.dispatcher.addEventListener("selectAllClick", selectAllButtonClick);
			website.mc_topPanel.dispatcher.addEventListener("editDescClick", editDescButtonClick);
			
			this.mc_uploader.setUploadUrl(urlUpload);
			
			//scrollbar events:
			this.mc_scrollBar.dispatcher.addEventListener("scrollBarMoving",scrollBarMovingHandler);
			
			//wheel event:
			this.addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
			
			//background events (when the all holders exists)
			this.mc_itemsArea.addEventListener(MouseEvent.MOUSE_DOWN,itemsAreaMouseDownHandler);
			this.mc_itemsArea.addEventListener(MouseEvent.MOUSE_UP,itemsAreaMouseUpHandler);
				  
			addChild(this.mc_holder);
			addChild(this.mc_uploader);
			addChild(this.selRectangle);
			
			formatCaptionText();
						
			resetPanel();
		}
		
		//--------------------------------------------------------
		// set context menu for images edit panel object
		public function setContextMenu(){
			var menu:ContextMenu = new ContextMenu();
			
			//upload to current category
			var	itemUpload:ContextMenuItem = new ContextMenuItem("Upload item to this category");
			itemUpload.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,uploadContextMenuClick);
			menu.customItems.push(itemUpload);
			
			//select all
			var	itemSelectAll:ContextMenuItem = new ContextMenuItem("Select all items");
			itemSelectAll.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,selectAllContextMenuClick);
			menu.customItems.push(itemSelectAll);
			
			menu.hideBuiltInItems();
			this.contextMenu = menu;
		}

		
		//--------------------------------------------------------------------------------		
		//resets once on login
		public function restart(){
			doUserPreveleges();
		}
		
		//--------------------------------------------------------------------------------		
		// format caption text (category text)
		function formatCaptionText(){
		    var format:TextFormat = new TextFormat();
			//format.bold = true;
			format.letterSpacing = 2;
			this.txtCategoryCaption.defaultTextFormat = format;
		}
		
		//--------------------------------------------------------------------------------		
		//check stage event add. add them only once.
		public function checkStageEvent(){
			if(this.flagStageLoaded == false && this.stage != null){
				stage.addEventListener(MouseEvent.MOUSE_MOVE,stageMouseMoveHandler);
				stage.addEventListener(MouseEvent.MOUSE_UP,stageMouseUpHandler);
				this.flagStageLoaded = true;
			}			
		}
		
		//---------------------------------------------------------------------
		// fill movie with as items area movieclip (as mc_itemsArea);
		private function fillMovieItemsArea(mc_clip:Sprite){			
			this.addChild(mc_clip);
			mc_clip.graphics.beginFill(0x00FF00);
			mc_clip.graphics.drawRect(0, 0, mc_back.width - mc_scrollBar.width - 0, mc_back.height - 0);
			mc_clip.graphics.endFill();
			mc_clip.x = mc_back.x;
			mc_clip.y = mc_back.y;
		}
		
		//---------------------------------------------------------------------
		//fill movie with field for mask (where the items will be shown
		private function fillMovieItemsArea_mask(mc_clip:Sprite){
			this.addChild(mc_clip);
			mc_clip.graphics.beginFill(0xFF0000);
			mc_clip.graphics.drawRect(0, 0, mc_back.width - mc_scrollBar.width - this.items_gapx_bottom-this.items_gapx, mc_back.height - this.items_gapy_bottom-this.items_gapy);
			mc_clip.graphics.endFill();
			mc_clip.x = mc_back.x+this.items_gapx;
			mc_clip.y = mc_back.y+this.items_gapy;
		}
		
		
		//---------------------------------------------------------------------		
		// resets the panel to default positions
		public function resetPanel(){
			this.mouseChildren = true;
			
			this.mc_holder.x = this.mc_mask.x;
			this.mc_holder.y = this.mc_mask.y;
						
			//position scrollbar
			this.mc_scrollBar.x = mc_mask.x + mc_mask.width;
			this.mc_scrollBar.y = mc_mask.y;
			
			this.mc_scrollBar.setHeight(mc_mask.height);
			this.mc_noItemsText.visible = false;
			
			this.txtCategoryCaption.text = "";
			this.txtCategoryCaptionId.text = "";
		}
		
		//custom configuration per user.
		//---------------------------------------------------------------------				
		public function doUserPreveleges(){			
			// hide the category id for users.
			if(MainClass.userType == "admin") this.txtCategoryCaptionId.visible = true;
			else this.txtCategoryCaptionId.visible = false;	//for users
		}

		//event from topPanel - editName button click. pass the event to mc_holder.
		//---------------------------------------------------------------------				
		private function editDescButtonClick(event:Event){
			mc_holder.editDescSelectedItem();
		}		
		
		//---------------------------------------------------------------------				
		//event from topPanel - select all button click. tell the holder to select all items.
		private function selectAllButtonClick(event:Event){
			mc_holder.selectAllItems();
		}		
		
		public function unselectAllItems(){
			mc_holder.unselectAllItems();
		}
		
		//---------------------------------------------------------------------		
		// get items array from the holder.
		public function getArrItems(){
			return(mc_holder.getArrItems());
		}
		
		//---------------------------------------------------------------------
		// completed upload files. tell parent that the items has been uploaded (for updating num uploaded files)
		// and update the items with those that has been uploaded.
		private function uploadCompetedHandler(event:Event){
			dispatcher.dispatchEvent(new Event("itemUploaded"));
		}				
		
		//---------------------------------------------------------------------
		// upload started
		private function uploadStartedHandler(event:Event){
			dispatcher.dispatchEvent(new Event("uploadStarted"));
		}
		
		//event from topPanel - editName button click. pass the event to mc_holder.
		private function editNameButtonClick(event:Event){
			var mc_website = this.parent;
			mc_website.hidePreviewPanel();
			mc_holder.editNameSelectedItem();
		}	
		
		//---------------------------------------------------------------------				
		//event from context menu: upload context menu click. start upload
		private function selectAllContextMenuClick(event:ContextMenuEvent){
			mc_holder.selectAllItems();
		}
		
		//---------------------------------------------------------------------				
		//event from context menu: upload context menu click. start upload
		private function uploadContextMenuClick(event:ContextMenuEvent){
			this.mc_uploader.startUpload();
		}
		
		//---------------------------------------------------------------------				
		//event from topPanel - upload button click - call uploader to upload files.
		private function uploadButtonClick(event:Event){
			this.mc_uploader.startUpload();
		}		
			
		//---------------------------------------------------------------------
		// event from holder - begin load next item
		private function holderItemBeginLoading(event:Event){
			//trace("holderItemBeginLoading");
		}

		//---------------------------------------------------------------------
		// event from holder - loading item in process
		private function holderLoadingInProcess(event:Event){
			//trace("holderLoadingInProcess");
		}

		//---------------------------------------------------------------------
		// event from holder - item loaded
		private function holderItemLoaded(event:Event){
			//trace("holderItemLoaded");
		}
		
		//---------------------------------------------------------------------
		// event from holder - all items loaded
		private function allHolderImagesLoaded(event:Event){
			//trace("allHolderImagesLoaded");
		}
		
		//----------------------------------------------------------------------
		//update scrollbar according the mc_holder diameters
		public function updateScrollbar(){
			mc_scrollBar.update(mc_holder.height,mc_holder.y,mc_mask.height,mc_mask.y);
		}
		
		//----------------------------------------------------------------------
		//load and show images on the panel
		public function setItems(listItems:XMLList,currentCategoryId,currentCategoryTitle){
			checkStageEvent();
			this.currentCategoryId = currentCategoryId;
			resetPanel();
			mc_uploader.setUploadCategoryId(this.currentCategoryId);
			mc_holder.setItems(listItems);
			setCaptionText(currentCategoryId,currentCategoryTitle);
			updateScrollbar();
		}
		
		//----------------------------------------------------------------------
		// set caption text
		public function setCaptionText(currentCategoryId,currentCategoryTitle){
			this.txtCategoryCaption.htmlText = "Category: <b>" + currentCategoryTitle + "</b>";
			this.txtCategoryCaptionId.htmlText = "Category ID: " + currentCategoryId;
		}
		
		//----------------------------------------------------------------------
		//show no images text
		public function showNoImagesText(show){
			this.mc_noItemsText.visible = show;
		}
		
		//----------------------------------------------------------------------
		// like set items, but add them to the end.
		public function addItems(listItems:XMLList){
			mc_holder.addItems(listItems);
			updateScrollbar();
		}
		
		//----------------------------------------------------------------------
		// duplicate selected item
		public function duplicateSelectedItem(){
			mc_holder.duplicateSelectedItem();
		}
		
		//---------------------------------------------------------------------				
		//preview selectected item
		public function previewSelectedItem(){
			this.mc_holder.previewSelectedItem();
		}		
		
		//----------------------------------------------------------------------
		// download selected item
		public function downloadSelectedItem(){
			mc_holder.downloadSelectedItem();
		}
		
		//----------------------------------------------------------------------
		// move pane to very top
		public function movePaneToTop(){
			this.mc_holder.y = mc_mask.y;
		}		
		
		//----------------------------------------------------------------------
		//select some item by id
		public function selectItemById(id:Number){
			this.mc_holder.selectItemById(id);
		}
		
		//----------------------------------------------------------------------
		// move pane by scrollbar
		public function movePaneByScrollbar(){
			var percent = mc_scrollBar.getPosPercent();
			if(mc_holder.height <= mc_mask.height) return(false);
						
			var holderMoveSpace = mc_holder.height - mc_mask.height;
			var holderPart = Math.ceil(holderMoveSpace * percent);
			this.mc_holder.y = mc_mask.y - holderPart;
		}
		
		//----------------------------------------------------------------------
		// invoked whtn the scrollbar moving, scroll the pane.
		private function scrollBarMovingHandler(event:Event){
			movePaneByScrollbar();
		}
		
		//----------------------------------------------------------------------
		// invoked when the wheel moving. move the scroller one down.
		private function mouseWheelHandler(event:MouseEvent){			   
			var dir:String = "down";
			if(event.delta > 0) dir="up";			
			this.mc_scrollBar.moveBar(40,dir);
			movePaneByScrollbar();
		}
		
		//----------------------------------------------------------------------
		// invoked when mouse down on items visible area
		private function itemsAreaMouseDownHandler(event:MouseEvent){
			this.selHolderStartPoint = new Point(mc_holder.mouseX,mc_holder.mouseY);
			this.flagSelectionStarted = true;
			selectionStartPoint = new Point(this.mouseX,this.mouseY);
			
			this.mc_holder.mouseEnabled = false;
			this.mc_holder.mouseChildren = false;
			
			this.mc_itemsArea.mouseChildren = false;
			this.mc_itemsArea.mouseEnabled = false;
		}
		
		//----------------------------------------------------------------------
		// event on stage mouse up. stops the selection.
		private function stageMouseUpHandler(event:MouseEvent){
			var keyPressed:String = "none";
			if(event.ctrlKey) keyPressed = "ctrl";
			if(event.shiftKey) keyPressed = "shift";
			
			if(this.flagSelectionStarted == true) stopSelection(keyPressed);			
		}
		
		//----------------------------------------------------------------------
		// event on itemsArea mouse up. pass event to items holder
		private function itemsAreaMouseUpHandler(event:MouseEvent){			
			mc_holder.onBlankAreaMouseUp();
		}
				
		//----------------------------------------------------------------------
		// stop items area selection.
		public function stopSelection(keyPressed:String){
			this.flagSelectionStarted = false;
			
			this.selRectangle.graphics.clear();
									
			var holderSecondPoint:Point = new Point(this.mc_holder.mouseX,this.mc_holder.mouseY);
			
			this.mc_holder.selectHoldersBySelection(selHolderStartPoint,holderSecondPoint,keyPressed);
			
			this.mc_holder.mouseEnabled = true;
			this.mc_holder.mouseChildren = true;
			
			this.mc_itemsArea.mouseChildren = true;
			this.mc_itemsArea.mouseEnabled = true;
		}
				
		//----------------------------------------------------------------------
		// stage mouse move event. draw a selection bar from the mouse down point to current point (just if the selection started)
		private function stageMouseMoveHandler(event:MouseEvent){
			if(this.flagSelectionStarted == true){				
				this.selRectangle.graphics.clear();
				this.selRectangle.graphics.lineStyle(1, 0x000000, 1, false, LineScaleMode.NONE,CapsStyle.SQUARE, JointStyle.MITER, 10);
				
				var secondX:Number = this.mouseX;
				var secondY:Number = this.mouseY;
				if(secondX < 0) secondX = 0;
				if(secondY < 0) secondY = 0;
				
				if(secondX > this.width) secondX = this.width;
				if(secondY > this.height) secondY = this.height;				
				
				this.selRectangle.graphics.moveTo(selectionStartPoint.x,selectionStartPoint.y);
				this.selRectangle.graphics.lineTo(secondX,selectionStartPoint.y);
				this.selRectangle.graphics.lineTo(secondX,secondY);
				this.selRectangle.graphics.lineTo(selectionStartPoint.x,secondY);
				this.selRectangle.graphics.lineTo(selectionStartPoint.x,selectionStartPoint.y);				
			}
		}
		
		
		//----------------------------------------------------------------------
		// get string of selected item ids in holder devided by commas
		public function getSelectedItemIds(){
			var strItemIDs:String = mc_holder.getSelectedItemIds()
			return(strItemIDs);			
		}
		
		//----------------------------------------------------------------------
		// get string of all item ids in holder devided by commas
		public function getStrItemIds(){
			var strItemIDs:String = mc_holder.getStrItemIds()
			return(strItemIDs);
		}
		
		//----------------------------------------------------------------------
		// verify that everything is ok , and show delete dialog.
		public function deleteSelectedStartOperation(){
			var website = this.parent;
			var numSelectedItems = this.mc_holder.getNumSelectedHolders();
			
			//if there is no selected items, show message dialog and don't continue.
			if(numSelectedItems == 0){
				website.showDialog("textonly","","There is no selected items to delete");
				return(false);
			}
			
			//single item delete. show the dialog from the item.
			if(numSelectedItems == 1){
				var arrSelectedItems:Array = this.mc_holder.getArrSelectedItems();
				var item:ItemHolder = arrSelectedItems[0];
				item.deleteSingleItemRequest();
			}
			else{	//multiple item delete. show the dialog
				website.showConfirmDialog("deleteItems","Do you sure that you want to delete all those items?");
			}			
		}
		
		//----------------------------------------------------------------------
		// top panel delete button click. show delete items dialog
		public function deleteButtonClick(event:Event){
			deleteSelectedStartOperation();
		}
		
		//----------------------------------------------------------------------
		// callback from the dialog to delete items. tell website what items to delete.
		public function deleteDialogCallback(toDelete:Boolean){
			if(toDelete == false) return(false);	//cancel click on the dialog. don't continue. 
			
			//continue deleting items.
			var website = this.parent;
			var strItemIds:String = mc_holder.getStrSelectedItemIDs();
			website.deleteCategoryItems(strItemIds);
		}
		
		//----------------------------------------------------------------------
		// remove items from the holder, toSelectNextItem: tells whether to select next item or not
		public function removeItems(listItems:XMLList,toSelectNextItem:Boolean){
			mc_holder.removeItems(listItems,toSelectNextItem);
			updateScrollbar();
			if(this.mc_scrollBar.isDisabled() == true) movePaneToTop();
		}
		
		//----------------------------------------------------------------------
		// update item name and description of item movies holder
		public function updateItemNameDesc(itemID:String,itemName:String,itemDesc:String,itemLink:String){
			this.mc_holder.updateItemNameDesc(itemID,itemName,itemDesc,itemLink);
		}
		
	}
}